<?php
date_default_timezone_set('Europe/Madrid');
setlocale(LC_TIME, 'spanish');
$ActualHourXML = date('H:i:s');
$ActualDateXML = date('Y-m-d');

$ID = $servicioID;
$sqlFomento ='SELECT servicio.id_servicio,
                    DATE_FORMAT(servicio.fecha, \'%d/%c/%Y\') as date,
                    servicio.lugarrecogida,
                    servicio.ineProvinciaOrigenServicio,
                    servicio.ineMunicipioOrigenServicio,				
                    servicio.lugardestino,
                    servicio.ineProvinciaDestinoServicio,
                    servicio.ineMunicipioDestinoServicio,				
                    TIME_FORMAT(servicio.horainicio, \'%H:%i\') as horainicio,
                    TIME_FORMAT(servicio.horafin, \'%H:%i\') as horafin,
                    servicio.idcliente,
                    servicio.idvehiculo,				
                    servicio.idtipodelegacion,
                    servicio.ineProvinciaContrato,
                    servicio.ineMunicipioContrato,
                    DATE_FORMAT(servicio.fechaContrato, \'%Y-%m-%d\') as dateContrato,
                    DATE_FORMAT(servicio.horaContrato, \'%H:%i:%s\') as horaContrato,
                    DATE_FORMAT(servicio.fecha, \'%Y-%m-%d\') as datePrevistaInicio,
                    DATE_FORMAT(servicio.horainicio, \'%H:%i:%s\') as horaPrevistaInicio,
                    DATE_FORMAT(servicio.fecha, \'%Y-%m-%d\') as dateFin,
                    clientes.idcliente,
                    vehiculo.idvehiculo,
                    vehiculo.matricula,
                    vehiculo.idtipocompania
                    FROM servicio
                    LEFT OUTER JOIN clientes ON servicio.idcliente = clientes.idcliente
                    LEFT OUTER JOIN vehiculo ON servicio.idvehiculo = vehiculo.idvehiculo
                    WHERE id_servicio = '.$ID;

$resultFomento = mysqli_query($conexio, $sqlFomento);

$nifTitular='';
while ($servicioFomento = mysqli_fetch_array($resultFomento))
{
    //TAXIVIPS
    if ((!empty($servicioFomento['idtipocompania'])) && ($servicioFomento['idtipocompania'] == '1'))
    {
        $nifTitular='40995326B';
    }
    //LIMOUSINES BARBANY	
    else if ((!empty($servicioFomento['idtipocompania'])) && ($servicioFomento['idtipocompania'] == '2'))
    {
        $nifTitular='B63075709';
    }
    //TAXVIP BARCELONA 2016
    else if ((!empty($servicioFomento['idtipocompania'])) && ($servicioFomento['idtipocompania'] == '4'))
    {
        $nifTitular='B43980820';
    }

    $xml = new DOMDocument('1.0');
    // we want a nice output
    $xml->formatOutput=true;

    $qaltavtc = $xml->createElement("vtc:qaltavtc");
    $qaltavtc->setAttribute("xmlns:vtc", "http://mfom.com/vtc");

    $header = $xml->createElement("header");
    $header->setAttribute("fecha", $ActualDateXML.'T'.$ActualHourXML);
    $header->setAttribute("version", '1.0');
    $header->setAttribute("versionsender", '1.0');
    $xml->appendChild($header);

    $body = $xml->createElement("body");
    $vtcservicio = $xml->createElement("vtcservicio");

    $vtcservicio->setAttribute("matricula", $servicioFomento['matricula']);
    $vtcservicio->setAttribute("niftitular", $nifTitular);
    //$vtcservicio->setAttribute("nif", $nifTitular);
    $vtcservicio->setAttribute("cgprovcontrato", $servicioFomento['ineProvinciaContrato']);
    $vtcservicio->setAttribute("cgmunicontrato", $servicioFomento['ineMunicipioContrato']);
    $vtcservicio->setAttribute("fcontrato", $servicioFomento['dateContrato'].'T'.$servicioFomento['horaContrato']);
    $vtcservicio->setAttribute("cgprovinicio", $servicioFomento['ineProvinciaOrigenServicio']);
    $vtcservicio->setAttribute("cgmuniinicio", $servicioFomento['ineMunicipioOrigenServicio']);
    $vtcservicio->setAttribute("direccioninicio", $servicioFomento['lugarrecogida']);
    $vtcservicio->setAttribute("fprevistainicio", $servicioFomento['datePrevistaInicio'].'T'.$servicioFomento['horaPrevistaInicio']);
    $vtcservicio->setAttribute("cgprovfin", $servicioFomento['ineProvinciaDestinoServicio']);
    $vtcservicio->setAttribute("cgmunifin", $servicioFomento['ineMunicipioDestinoServicio']);
    $vtcservicio->setAttribute("direccionfin", $servicioFomento['lugardestino']);
    $vtcservicio->setAttribute("ffin", $servicioFomento['dateFin']);
    $vtcservicio->setAttribute("cgprovlejano", $servicioFomento['ineProvinciaDestinoServicio']);
    $vtcservicio->setAttribute("cgmunilejano", $servicioFomento['ineMunicipioDestinoServicio']);
    $vtcservicio->setAttribute("direccionlejano", $servicioFomento['lugardestino']);
    $vtcservicio->setAttribute("veraz", 'S');

    $body->appendChild($vtcservicio);
    $xml->appendChild($body);

    $qaltavtc->appendChild($header);
    $qaltavtc->appendChild($body);

    $xml->appendChild($qaltavtc);

    echo '<xmp>'.'return : '.$xml->saveXML().'</xmp>';

    $fomento = $xml->saveXML(); // put string in fomento
    $xml->save('fomento.xml'); // save as file

    $row_number = 0;    // Number of the line we are deleting
    $file_out = file("fomento.xml"); // Read the whole file into an array

    //Delete the recorded line
    unset($file_out[$row_number]);

    //Recorded in a file
    file_put_contents("../fomento/xml/fomento.xml", implode("", $file_out));
}    
?>